#ifndef __CMenuItemDisplay__
#define __CMenuItemDisplay__

#include "CControlPanel.hpp"
#include "CMenuItem.hpp"
#include "CTextLabel.hpp"
#include "CImageLabel.hpp"
#include <Mathtools/CBounds.hpp>
#include <Collections/TAutomaticPointer.hpp>
#include "SMenuColours.hpp"

//	===========================================================================

using Exponent::Collections::TAutomaticPointer;
using Exponent::GUI::Controls::CControlPanel;
using Exponent::GUI::Controls::CMenuItem;
using Exponent::GUI::Controls::CTextLabel;
using Exponent::GUI::Controls::CImageLabel;
using Exponent::MathTools::CBounds;
using Exponent::GUI::Controls::SMenuColours;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CMenuItemDisplay CMenuItemDisplay.hpp
			 * @brief Displays a single menu item
			 *
			 * @date 15/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CMenuItemDisplay.hpp,v 1.8 2007/02/08 21:07:54 paul Exp $
			 */
			class CMenuItemDisplay : public CControlPanel
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				const static long CMENUITEM_DISPLAY_WIDTH_FROM_LEFT = 24;				/**< Distance from the left */
				const static long CMENUITEM_DISPLAY_WIDTH_FROM_RIGHT = 48;				/**< Distance from the right */
				const static long CMENUITEM_DISPLAY_SEPERATOR_WIDTH_FROM_RIGHT = 12;	/**< Distance for the seperator */

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control
				 * @param uniqueId The id of this control
				 * @param area The area of this control
				 * @param menuItem The menu item to display
				 * @param useIcons If true icons are drawn, if false they are not
				 * @param selectable If true the itemis a selectable entry
				 * @param subMenu If true item has submenu
				 * @param iconSize The size of the icons if used
				 */
				CMenuItemDisplay(IControlRoot *root, const long uniqueId, const CRect &area, CMenuItem *menuItem, const bool useIcons, const bool selectable, const bool subMenu, const long iconSize);

				/**
				 * Destruction
				 */
				virtual ~CMenuItemDisplay();

//	===========================================================================

				/**
				 * Set the menu item
				 * @param item The item to display
				 */
				virtual void setMenuItem(CMenuItem *item);

				/**
				 * Get the menu item
				 * @retval const CMenuItem* The menu item
				 */
				virtual const CMenuItem *getMenuItem() const { return m_menuItem.getPointer(); }

				/**
				 * Get the menu item
				 * @retval CMenuItem* The menu item
				 */
				virtual CMenuItem *getMutableMenuItem() { return m_menuItem.getMutablePointer(); }

//	===========================================================================

				/**
				 * Set the font
				 * @param font The font to draw with
				 */
				virtual void setFont(CFont *font);

				/**
				 * Set the colours
				 * @param colours The menu colours
				 */
				virtual void setColours(const SMenuColours &colours);

//	===========================================================================

				/**
				 * Is the mouse over this control
				 * @param mouseOver True if you want to spoof mouse over, false otherwise
				 * @note Intended for internal use, though can be called directly
				 */
				virtual void mouseIsOver(const bool mouseOver = true);

				/**
				 * Use icons
				 * @param useIcons If true icons are drawn, if false they are not
				 */
				virtual void useIcons(const bool useIcons = true) { m_useIcons = useIcons; }

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				/** 
				 * @class CMenuItemSubMenuPointer CMenuItemDisplay.hpp
				 * @brief Basic Class to draw the sub menu item pointer
				 */
				class CMenuItemSubMenuPointer : public CControl
				{
					/** @cond */
					EXPONENT_CLASS_DECLARATION;
					/** @endcond */

				public:

					/**
					 * Construction
					 * @param root The root control
					 * @param uniqueId The id of this control
					 * @param area The area of this control
					 */
					CMenuItemSubMenuPointer(IControlRoot *root, const long uniqueId, const CRect &area);

					/**
					 * Destruction
					 */
					virtual ~CMenuItemSubMenuPointer();

					/**
					 * Draw the control
					 * @param graphics The graphics context
					 */
					virtual void drawControl(CGraphics &graphics);

					/**
					 * Set the pointer colours
					 * @param pointerColour The colour of the pointer
					 */
					void setPointerColours(const CAlphaColour &pointerColour) 
					{
						m_pointerColour = pointerColour;
						this->update();
					}

				protected:

					CAlphaColour m_pointerColour;				/**< Colour of the arrow */
				};

				/** 
				 * @class CMenuItemSelectable CMenuItemDisplay.hpp
				 * @brief Basic Class to selection tick or x mark
				 */
				class CMenuItemSelectable : public CControl
				{
					/** @cond */
					EXPONENT_CLASS_DECLARATION;
					/** @endcond */

				public:

					/**
					 * Construction
					 * @param root The root control
					 * @param uniqueId The id of this control
					 * @param area The area of this control
					 * @param item The menu item
					 */
					CMenuItemSelectable(IControlRoot *root, const long uniqueId, const CRect &area, CMenuItem *item);

					/**
					 * Destruction
					 */
					virtual ~CMenuItemSelectable();

					/**
					 * Draw the control
					 * @param graphics The graphics context
					 */
					virtual void drawControl(CGraphics &graphics);

					/**
					 * Set the menu item
					 * @param item The menu item
					 */
					void setMenuItem(CMenuItem *item) { m_menuItem = item; }

				protected:

					TAutomaticPointer<CMenuItem> m_menuItem;					/**< The menu item */
				};

//	===========================================================================

				SMenuColours m_colours;											/**< The colours of the menu */
				bool m_mouseOver;												/**< The mouse is over this control */
				bool m_useIcons;												/**< Should we draw icons */
				bool m_hasSubMenu;												/**< Is there a sub menu? */
				bool m_hasSelect;												/**< Is there a select? */
				long m_iconSize;												/**< What is the icon size.. */

				TAutomaticPointer<CMenuItem> m_menuItem;						/**< The menu item */
				TAutomaticPointer<CTextLabel> m_titleLabel;						/**< The title label */
				TAutomaticPointer<CImageLabel> m_imageLabel;					/**< The image label */
				TAutomaticPointer<CMenuItemSubMenuPointer> m_subMenuPointer;	/**< The sub menu arrow pointer */
				TAutomaticPointer<CMenuItemSelectable> m_selectableControl;		/**< The selectable tick */
			};
		}
	}
}
#endif	// End of CMenuItemDisplay.hpp